<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Checkmate - Tenant Verification</title>

  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
</head>
<body>
<?php if(isset($_GET["success"])): ?>
  <div style="padding:12px; background:#d1fae5; margin:12px 0; border-radius:10px;">
    ✅ Request submitted successfully. Ref ID: <?php echo htmlspecialchars($_GET["request_id"] ?? ""); ?>
  </div>
<?php endif; ?>

<?php if(isset($_GET["error"])): ?>
  <div style="padding:12px; background:#fee2e2; margin:12px 0; border-radius:10px;">
    ❌ Error: <?php echo htmlspecialchars($_GET["error"]); ?>
  </div>
<?php endif; ?>

  <!-- NAVBAR -->
  <header class="navbar">
    <div class="container nav-inner">
      <div class="logo img"><img src="assets/images/icons/logo-pcE8n97y.png" alt="Checkmate"/></div>

      <nav class="nav-links">
        <a href="#">Services</a>
        <a href="#">How It Works</a>
        <a href="#">Pricing</a>
        <a href="#">Contact</a>
      </nav>

      <div class="nav-actions">
  <?php if(isset($_SESSION["user_id"])): ?>
    <a href="/checkmate/auth/logout.php" class="login">Logout</a>
    <a href="/checkmate/dashboard.php" class="btn-primary">Dashboard</a>
  <?php else: ?>
    <a href="/checkmate/auth/login.php" class="login">Log In</a>
    <a href="/checkmate/start.php" class="btn-primary">Get Started</a>
  <?php endif; ?>
</div>     

      </div>
    </div>
  </header>

 <!-- HERO -->
<section class="hero" id="home">

  <div class="container hero-content">

    <div class="badge">
      Trusted by 2,500+ Property Managers
    </div>

    <h1>
      Verify Tenants with
      <span>Complete Confidence</span>
    </h1>

    <p>
      Comprehensive rental history verification with work orders,
      violations, and unit condition reports. Know exactly how tenants
      treat properties before you sign.
    </p>

    <div class="hero-buttons">
      <button class="btn-primary large">Start Free Verification →</button>
      <button class="btn-outline large">Watch Demo</button>
    </div>

    <div class="stats">
      <div>
        <h3>24h</h3>
        <p>Average Report Time</p>
      </div>
      <div>
        <h3>99.8%</h3>
        <p>Accuracy Rate</p>
      </div>
      <div>
        <h3>50k+</h3>
        <p>Verifications Completed</p>
      </div>
    </div>

  </div>

  <!-- WAVE INSIDE HERO -->
  <div class="hero-wave">
    <svg viewBox="0 0 1440 120" preserveAspectRatio="none">
      <path d="M0,60 C360,120 1080,0 1440,70 L1440,120 L0,120 Z"
            fill="#F5F7FA"></path>
    </svg>
  </div>

</section>

  </section>
    <!-- SERVICES -->
  <section class="services" id="services">
    <div class="container">

      <div class="section-label">OUR SERVICES</div>
      <h2 class="section-title">Deep Rental History Insights</h2>
      <p class="section-subtitle">
        Go beyond surface-level checks. We uncover the real story of how tenants treat properties.
      </p>

      <div class="services-grid">
        <article class="service-card">
          <div class="service-icon">🏠</div>
          <h3>Complete Rental History</h3>
          <p>Deep dive into every aspect of a tenant's rental history including payment patterns, lease compliance, and landlord relationships.</p>
        </article>

        <article class="service-card">
          <div class="service-icon">🛠️</div>
          <h3>Work Order Analysis</h3>
          <p>See exactly how many maintenance requests and work orders were filed during the tenancy — understand the tenant's care level.</p>
        </article>

        <article class="service-card">
          <div class="service-icon">⚠️</div>
          <h3>Violation Tracking</h3>
          <p>Full report on any lease violations, noise complaints, or policy infractions during previous tenancies.</p>
        </article>

        <article class="service-card">
          <div class="service-icon">📋</div>
          <h3>Unit Condition Reports</h3>
          <p>Move-in vs. move-out condition comparisons showing how tenants treated the property over time.</p>
        </article>

        <article class="service-card">
          <div class="service-icon">📄</div>
          <h3>Landlord References</h3>
          <p>Direct verification with previous landlords including detailed questionnaires about tenant behavior and reliability.</p>
        </article>

        <article class="service-card">
          <div class="service-icon">📈</div>
          <h3>Tenant Score</h3>
          <p>Our proprietary scoring system combines all data points into an easy-to-understand tenant quality score.</p>
        </article>
      </div>

    </div>
  </section>

  <!-- HOW IT WORKS -->
<section class="how-it-works">
  <div class="container">

    <div class="section-header">
      <span class="section-label">HOW IT WORKS</span>
      <h2>Simple, Fast, Reliable</h2>
      <p>
        Get comprehensive tenant verification in four easy steps.
      </p>
    </div>

    <div class="steps">

      <div class="step-card">
        <div class="step-number">01</div>
        <div class="step-icon">📄</div>
        <h3>Submit Application</h3>
        <p>Enter tenant information through our secure portal or invite tenants to apply directly.</p>
      </div>

      <div class="step-card">
        <div class="step-number">02</div>
        <div class="step-icon">🔍</div>
        <h3>We Investigate</h3>
        <p>Our team conducts thorough background checks across multiple databases and verification sources.</p>
      </div>

      <div class="step-card">
        <div class="step-number">03</div>
        <div class="step-icon">📊</div>
        <h3>Review Report</h3>
        <p>Receive a comprehensive, easy-to-read report with all findings and a clear recommendation.</p>
      </div>

      <div class="step-card">
        <div class="step-number">04</div>
        <div class="step-icon">✅</div>
        <h3>Make Decision</h3>
        <p>Use our detailed insights to make an informed decision about your prospective tenant.</p>
      </div>

    </div>
  </div>
</section>
<!-- DARK STATS SECTION -->
<section class="stats-dark">
  <div class="container stats-grid">

    <div class="stat-item">
      <h3>50,000+</h3>
      <p>Verifications Completed</p>
    </div>

    <div class="stat-item">
      <h3>2,500+</h3>
      <p>Property Managers Trust Us</p>
    </div>

    <div class="stat-item">
      <h3>99.8%</h3>
      <p>Accuracy Rate</p>
    </div>

    <div class="stat-item">
      <h3>&lt; 24hrs</h3>
      <p>Average Turnaround</p>
    </div>

  </div>
</section>
<section class="cta-section">
  <div class="container">
    <div class="cta-box">

      <h2>Ready to Screen Smarter?</h2>

      <p>
        Join thousands of property managers who trust Checkmate for reliable,
        fast tenant verifications. Start protecting your investments today.
      </p>

      <div class="cta-buttons">
        <button class="btn-primary large">Get Started Free →</button>
        <button class="btn-outline-light large">📞 Schedule a Call</button>
      </div>

      <small>No credit card required • First verification free</small>

    </div>
  </div>
</section>

<!-- FOOTER -->
<footer class="footer" id="contact">
  <div class="container footer-inner">
    <!-- Left brand block -->
    <div class="footer-brand">
      <div class="footer-logo">
        <!-- Replace with your logo image -->
        <img src="assets/images/icons/logo-pcE8n97y.png" alt="Checkmate"/>
      </div>

      <p class="footer-desc">
        Trusted tenant verification services helping property managers make confident decisions since 2020.
      </p>

      <div class="footer-contact">
        <a class="footer-contact-item" href="mailto:info@checkmateverify.com">
          <span class="icon">✉</span> info@checkmateverify.com
        </a>
        <a class="footer-contact-item" href="tel:+18005550123">
          <span class="icon">☎</span> 1-800-555-0123
        </a>
      </div>
    </div>

    <!-- Link columns -->
    <div class="footer-cols">
      <div class="footer-col">
        <h4>Services</h4>
        <ul>
          <li><a href="#services">Rental History</a></li>
          <li><a href="#services">Work Order Reports</a></li>
          <li><a href="#services">Violation Tracking</a></li>
          <li><a href="#services">Unit Condition Reports</a></li>
          <li><a href="#services">Tenant Scoring</a></li>
        </ul>
      </div>

      <div class="footer-col">
        <h4>Company</h4>
        <ul>
          <li><a href="#about">About Us</a></li>
          <li><a href="#pricing">Pricing</a></li>
          <li><a href="#blog">Blog</a></li>
          <li><a href="#careers">Careers</a></li>
          <li><a href="#contact">Contact</a></li>
        </ul>
      </div>

      <div class="footer-col">
        <h4>Legal</h4>
        <ul>
          <li><a href="#privacy">Privacy Policy</a></li>
          <li><a href="#terms">Terms of Service</a></li>
          <li><a href="#fcra">FCRA Compliance</a></li>
          <li><a href="#security">Data Security</a></li>
        </ul>
      </div>
    </div>
  </div>

  <div class="container footer-bottom">
    <div class="footer-bottom-inner">
      <p class="footer-copy">© 2024 Checkmate Tenant Verifications. All rights reserved.</p>
      <div class="footer-loc">
        <span class="loc-dot">📍</span> United States
      </div>
    </div>
  </div>
</footer>


  <!-- VERIFICATION MODAL -->
<div class="modal-overlay" id="getStartedModal">
  <div class="modal-box">
    <button class="modal-close" id="closeGetStarted">×</button>

    <h2>Start Verification Request</h2>

    <form id="verificationForm" method="POST" action="forms/verification.php" enctype="multipart/form-data">

  <!-- STEP 1 -->
  <div class="form-step active">
    <h3>Step 1: Your Company Information</h3>

    <label>Company Name *</label>
    <input type="text" name="company_name" required>

    <label>LLC / Property Owner Name *</label>
    <input type="text" name="owner_name" required>

    <label>Your Email *</label>
    <input type="email" name="email" required>

    <label>Your Phone *</label>
    <input type="tel" name="phone" required>

    <button type="button" class="next-step">Continue →</button>
  </div>

  <!-- STEP 2 -->
  <div class="form-step">
    <h3>Step 2: Tenant Information</h3>

    <label>Tenant Full Name *</label>
    <input type="text" name="tenant_name" required>

    <label>Tenant Email *</label>
    <input type="email" name="tenant_email" required>

    <label>Tenant Phone *</label>
    <input type="tel" name="tenant_phone" required>

    <button type="button" class="prev-step">← Back</button>
    <button type="button" class="next-step">Continue →</button>
  </div>

  <!-- STEP 3 -->
  <div class="form-step">
    <h3>Step 3: Current Rental Address</h3>

    <label>Street Address *</label>
    <input type="text" name="street" required>

    <label>City *</label>
    <input type="text" name="city" required>

    <label>State *</label>
    <input type="text" name="state" required>

    <label>ZIP Code *</label>
    <input type="text" name="zip" required>

    <label>Move In Date *</label>
    <input type="date" name="move_in" required>

    <label>Move Out Date *</label>
    <input type="date" name="move_out" required>

    <button type="button" class="prev-step">← Back</button>
    <button type="button" class="next-step">Continue →</button>
  </div>

  <!-- STEP 4 -->
  <div class="form-step">
    <h3>Step 4: Upload Tenant Application</h3>

    <label>Upload Application (PDF, DOC, DOCX, JPG, PNG — Max 10MB)</label>
    <input type="file" name="application_file"
      accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" required>

    <button type="button" class="prev-step">← Back</button>
    <button type="button" class="next-step">Continue →</button>
  </div>

  <!-- STEP 5 -->
  <div class="form-step">
    <h3>Step 5: Acknowledgement & Signature</h3>

    <label>
      <input type="checkbox" name="agree" required>
      I confirm that all information provided is accurate and I agree to the terms.
    </label>

    <button type="button" class="prev-step">← Back</button>
    <button type="submit" class="btn-primary">Submit Request →</button>
  </div>

</form>

  </div>
</div>
<script src="script.js"></script>
</body>
</html>
