<?php
require_once __DIR__ . "/../includes/config.php";
require_once __DIR__ . "/../includes/db.php";

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $name = trim($_POST["full_name"] ?? "");
  $email = trim($_POST["email"] ?? "");
  $password = $_POST["password"] ?? "";

  if ($name === "" || $email === "" || $password === "") {
    $error = "All fields are required.";
  } else {
    $hash = password_hash($password, PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO users (full_name, email, password_hash) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $name, $email, $hash);

    if ($stmt->execute()) {
      header("Location: " . BASE_URL . "/auth/login.php?registered=1");
      exit();
    } else {
      $error = "Email already exists (or error creating account).";
    }
  }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Sign Up</title></head>
<body>
  <h2>Create Account</h2>
  <?php if($error): ?><p style="color:red;"><?php echo $error; ?></p><?php endif; ?>

  <form method="POST">
    <input name="full_name" placeholder="Full Name" required><br><br>
    <input name="email" type="email" placeholder="Email" required><br><br>
    <input name="password" type="password" placeholder="Password" required><br><br>
    <button type="submit">Create Account</button>
  </form>

  <p>Already have an account? <a href="<?php echo BASE_URL; ?>/auth/login.php">Login</a></p>
</body>
</html>
